// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 ViewProj;
   float4x4 View;
   float4x4 PrevViewProj;

//--------------
// tweaks
//--------------  
   float2 ViewSize;
   float Offset=4.0;
   float MotionVec=0.025;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
         Texture=<RenderTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
      {
         float4 Pos:POSITION;
      };
   struct OutPut
      {
         float4 Pos:POSITION; 
         float4 Project:TEXCOORD0;
         float4 CurrPos:TEXCOORD1;
         float4 PrevPos:TEXCOORD2;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
      {
         OutPut OUT;
         OUT.Pos=mul(mul(IN.Pos,World),ViewProj);
         OUT.Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
         OUT.CurrPos=OUT.Pos;
         OUT.PrevPos=mul(mul(IN.Pos,World),PrevViewProj);
         return OUT;
     }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
         IN.Project.xy=(IN.Project/IN.Project.w)+ViewSize.xyyy;
         float Depth=1.0/(1.0+(tex2Dlod(RenderSampler,IN.Project).w/1000.0));
         float2 PixelVelocity=(IN.CurrPos.xy/IN.CurrPos.w)-(IN.PrevPos.xy/IN.PrevPos.w);
         PixelVelocity=clamp(float2(-PixelVelocity.x*0.5,PixelVelocity.y*0.5)*(Depth+0.5),-1.0,1.0);
         float Mask=abs(PixelVelocity.x)+abs(PixelVelocity.y);
         PixelVelocity *=MotionVec;
         float3 FrameRender=0.0;
         for (int i=-8; i < 9; i++) FrameRender +=tex2Dlod(RenderSampler,IN.Project+PixelVelocity.xyyy*i).xyz;
         return float4(FrameRender/17.0,saturate(Mask*64.0));
     }

//--------------
// techniques   
//--------------
   technique Downfilter
      {
         pass p1
      {         
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS();
         zwriteenable=false;
         zenable=false;
         ZFunc=always;
      }
      }
